/* test.c -- testing ground for passing a struct into assembler */

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>

typedef struct {
	unsigned long eax;
	unsigned long ebx;
	unsigned long ecx;
	unsigned long edx;
	unsigned long esi;
	unsigned long edi;
} SMMRegisters;

extern SMMRegisters reg;

int tosh_smm(SMMRegisters *reg)
{
	int eax;

	asm ("subl $8,%%esp\n" \
		"# save all the registers that might be changed\n\t" \
		"pushl %%edi\n\t" \
		"pushl %%esi\n\t" \
		"pushl %%ebx\n" \
		"# load the values into the registers\n\t" \
		"movl 8(%%ebp),%%eax\n\t" \
		"movl (%%eax),%%edx\n\t" \
		"push %%edx\n\t" \
		"movl 4(%%eax),%%ebx\n\t" \
		"movl 8(%%eax),%%ecx\n\t" \
		"movl 12(%%eax),%%edx\n\t" \
		"movl 16(%%eax),%%esi\n\t" \
		"movl 20(%%eax),%%edi\n\t" \
		"popl %%eax\n" \
		"# call the System Management mode\n\t" \
		"inb $0xb2,%%al\n"
		"# fill out the memory with the values in the registers\n\t" \
		"pushl %%eax\n\t"
		"movl 8(%%ebp),%%eax\n\t" \
		"movl %%ebx,4(%%eax)\n\t" \
		"movl %%ecx,8(%%eax)\n\t" \
		"movl %%edx,12(%%eax)\n\t" \
		"movl %%esi,16(%%eax)\n\t" \
		"movl %%edi,20(%%eax)\n\t" \
		"popl %%edx\n\t" \
		"movl %%edx,(%%eax)\n" \
		"# setup the return value to the carry flag\n\t" \
		"lahf\n\t" \
		"shrl $8,%%eax\n\t" \
		"andl $1,%%eax\n\t" \
		"leal -20(%%ebp),%%esp\n"
		"# restore the registers before the call\n\t" \
		"popl %%ebx\n\t" \
		"popl %%esi\n\t" \
		"popl %%edi\n"
		: "=eax" (eax) : : "memory");

	return eax;
}
