/* hotkey.h -- graphics and text strings for hotkey
 *
 * Copyright (c) 1998  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * Portuguese translations by Joao Carlos Ventura <jcv@poboxes.com>
 * French translations by Tristan Debeaupuis <Tristan.Debeaupuis@hsc.fr>
 * Japanese translations by Daisuke Sato <densuke@ga2.so-net.ne.jp>
 * German translations by Harald Ganzinger <hg@mpi-sb.mpg.de>
 * Spanish translations by Juan Pablo Zaldivar Carrillo <saruman@orthanc.mx>
 *
 * $Log: hotkey.h,v $
 * Revision 1.7  2000/01/15 10:35:46  jab
 * added the model type enumerations
 *
 * Revision 1.6  1998/11/04 21:41:56  jab
 * added graphics and text strings for the speaker changing
 * added Spanish translations
 *
 * Revision 1.5  1998/06/27 21:42:46  jab
 * added German language strings
 *
 * Revision 1.4  1998/06/15 21:17:02  jab
 * Japanese strings added, and graphics modified for monochrome option
 *
 * Revision 1.3  1998/06/13 19:29:21  jab
 * French strings added
 *
 * Revision 1.2  1998/05/08 22:59:48  jab
 * internationalized and Portuguese strings added
 *
 * Revision 1.1  1998/05/05 16:52:46  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */


enum { STOCKHOLM, DERBY, MAUI };

enum { ENGLISH, SPANISH, FRENCH, GERMAN, ITALIAN, PORTUGUESE, JAPANESE };

static char *boot[7][2] = {
{"Resume Off", "Resume On"},
{"Modo de Reinicializacin", "Modo Suspender"},
{"Rsume Dsactiv", "Rsume Activ"},
{"Wiederaufnahmemodus aus", "Wiederaufnahmemodus ein"},
{"Resume Off", "Resume On"},
{"Modo Reinicializao", "Modo Pausa"},
{"쥸塼ࡧʤ", "쥸塼ࡧ"}};

static char *save[7][4] = {
{"Low Power", "Economy", "Full Power", "User Settings"},
{"Consumo mnimo", "Ahorro de energa", "Consumo mximo", "Parmetros del usuario"},
{"Conso Basse", "Economie", "Conso Maximale", "Choix de l'utilisateur"},
{"Energieverbrauch niedrig", "Energieverbrauch mittel", "Energieverbrauch hoch", "Benutzereinstellungen"},
{"Low Power", "Economy", "Full Power", "User Settings"},
{"Consumo Mnimo", "Economia", "Consumo Mximo", "Opes do Utilizador"},
{"", "", "եѥ", "桼"}};

static char *speaker[7][4] = {
{"Speaker Off", "Low Volume", "Medium Volume", "High Volume"},
{"Speaker Off", "Low Volume", "Medium Volume", "High Volume"},
{"Arrt du Haut-Parleur", "Volume Faible", "Volume Moyen", "Volume Fort"},
{"Lautsprecher aus", "geringe Lautstrke", "mittlere Lautstrke", "hohe Lautstrke"},
{"Speaker Off", "Low Volume", "Medium Volume", "High Volume"},
{"Som Desligado", "Volume Baixo", "Volume Medio", "Volume Alto"},
{"ԡ ", "ܥ塼 ", "ܥ塼 ", "ܥ塼 "}};


enum {
	BLACK  = 0,
	RED    = 1,
	BLUE   = 2,
	YELLOW = 3,
	SILVER = 4,
	GRAY   = 5,
	OLIVE  = 6,
	MARRON = 7,
	NAVY   = 8,
	WHITE  = 9
};

static unsigned short rgb[10][3] = {
	{0x0000, 0x0000, 0x0000}, {0xffff, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xffff}, {0xffff, 0xffff, 0x0000},
	{0xc000, 0xc000, 0xc000}, {0x8000, 0x8000, 0x8000},
	{0xc000, 0xc000, 0x0000}, {0xc000, 0x0000, 0x0000},
	{0x0000, 0x0000, 0xc000}, {0xffff, 0xffff, 0xffff}};

static char mono[14] = {1,0,1,0,0,1,1,0,1,1,1,0,0,1};

static char resumeon[32][32] = {
"                 0000           ",
"                 0  0           ",
"                 0  0           ",
"                 0 0            ",
"                000000          ",
"                010110          ",
"                011110          ",
"                011110          ",
"          0000000111100004      ",
"        00<<<<<<011110<<<0      ",
"       0<<<<<<<00000000040;     ",
"      0<<<<<<<<<<<<<<<<040;     ",
"      000000000000000<4040;     ",
"      06767676767676704040;     ",
"      07676767676767604040;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      07676767676767604440;     ",
"      06767676767676704440;     ",
"      0767676767676760400;;     ",
"      06767676767676700;;       ",
"      4000000000000000;         ",
"       4;;;;;;;;;;;;;;          "};


static char resumeoff[32][32] = {
"            ::::::::            ",
"         ::::::::::::::         ",
"       :::::      0 :::::       ",
"      :::         0 0  :::      ",
"     :::         000000 :::     ",
"    :::          010110   ::    ",
"   :: ::         011110    ::   ",
"  :::  ::        011110    :::  ",
"  ::    :: 0000000111100004 ::  ",
" ::      ::<<<<<<011110<<<0  :: ",
" ::     0<::<<<<00000000040; :: ",
" ::    0<<<::<<<<<<<<<<<040; :: ",
"::     00000::00000000<4040;  ::",
"::     067676::767676704040;  ::",
"::     0767676::76767604040;  ::",
"::     06767676::7676704440;  ::",
"::     076767676::767604440;  ::",
"::     0676767676::76704440;  ::",
"::     07676767676::7604440;  ::",
"::     067676767676::704440;  ::",
" ::    0767676767676::04440; :: ",
" ::    06767676767676::4440; :: ",
" ::    076767676767676::440; :: ",
"  ::   0676767676767670::40;::  ",
"  :::  07676767676767604::0:::  ",
"   ::  067676767676767044::::   ",
"    :: 0767676767676760444::    ",
"     :::6767676767676704:::     ",
"      :::67676767676760:::      ",
"       :::::67676767:::::       ",
"         ::::::::::::::         ",
"            ::::::::            "};


static char fullpower[32][32] = {
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"                99999999        ",
"                =444444=        ",
"                =444444=        ",
"                00544500        ",
"                  0440          ",
"                  0440          ",
"                 =4444=      ==5",
"            =====4<4444======<<5",
"           =<<<<4<444444<<<<<445",
"          =<44444444444455555545",
"          =<45554444444555555555",
"          =44500=444445500000955",
"          =440  554445550    555",
"          5550  05555550     000",
"                 055550         ",
"    2      2      0000          ",
"   22 2   222   2 8             ",
"   2  2 2 222 2 2  2            ",
"  22 22 2     2 22 22           ",
"  2  2  2  2  2  2  2           ",
" 22 22 22  2  22 22 22          ",
" 22 22 22 222 22 22 22          ",
"22  2  22 222 22  2  22         ",
"22 22 22  222  22 22 22         ",
"2  22 22  222  22 22 22         ",
"   22 22  222  22 22            ",
"      22  222  22               "};


static char lowpower[32][32] = {
"                                ",
"                                ",
"                                ",
"                                ",
"                                ",
"            99999999            ",
"            =444444=            ",
"            =444444=            ",
"            00544500            ",
"              0440              ",
"              0440              ",
"             =4444=      ==5    ",
"        =====4<4444======<<5    ",
"       =<<<<4<444444<<<<<445    ",
"      =<44444444444455555545    ",
"      =<45554444444555555555    ",
"      =44500=444445500000955    ",
"      =440  554445550    555    ",
"      5550  05555550     000    ",
"             055550             ",
"       2      0000              ",
"      222                       ",
"      222                       ",
"                                ",
"       2                        ",
"       2                        ",
"      222                       ",
"      222                       ",
"                                ",
"                                ",
"                                ",
"                                "};

static char userpower[32][32] = {
"                  :3:3:3:3:3:3:3",
"                <:<:<:<:<:<:<:<:",
"              :3:3:3:3:3:3:3:3:3",
"             :<:<:<:<:<:<:<:<:<:",
"            :3:355555555:3:3:3:3",
"            <:<5<<<<<<<<55<:<:  ",
"            :3:544444440  53:3  ",
"            <:5 4<444440  5:<:  ",
"            :35 0054400  5:3:   ",
"            :5    040   5:<:    ",
"            5     040   53:     ",
"                 =444=0 55   ==5",
"            =====4<4444======<<5",
"           =<<<<4<444444<<<<<445",
"          =<44444444444455555545",
"          =<45554444444555555555",
"          =44500=444445500000955",
"          =440  554445550    555",
"          5550  05555550     000",
"                 055550         ",
"    2      2      0000          ",
"   22 2   222   2 8             ",
"   2  2 2 222 2 2  2            ",
"  22 22 2     2 22 22           ",
"  2  2  2  2  2  2  2           ",
" 22 22 22  2  22 22 22          ",
" 22 22 22 222 22 22 22          ",
"22  2  22 222 22  2  22         ",
"22 22 22  222  22 22 22         ",
"2  22 22  222  22 22 22         ",
"   22 22  222  22 22            ",
"      22  222  22               "};


static char speakeroff[32][32] = {
"            ::::::::            ",
"         ::::::::::::::         ",
"       :::::        :::::       ",
"      :::              :::      ",
"     :::             =0 :::     ",
"    :::            4=40   ::    ",
"   :::::          4=4=0    ::   ",
"  ::: :::       =4=4=<0    :::  ",
"  ::   :::     =4=4<<<0     ::  ",
" ::     :::  4=4=<<<<=0      :: ",
" ::      :::4=4<<<<4=40      :: ",
" ::   =4=4:::<<<<=4=450      :: ",
"::    9<<<<:::<4=4=5550       ::",
"::    9<<<<<:::=4555550       ::",
"::    =4=4=4=:::5555550       ::",
"::    55555555:::555550       ::",
"::    555555555:::55550       ::",
"::    5555555555:::5550       ::",
"::    55555555555:::550       ::",
"::    555555555555:::50       ::",
" ::    000005555555:::0      :: ",
" ::         05555555:::      :: ",
" ::          00555555:::     :: ",
"  ::           0555555:::   ::  ",
"  :::           0055550::: :::  ",
"   ::             05550 :::::   ",
"    ::             0050  :::    ",
"     :::             00 :::     ",
"      :::              :::      ",
"       :::::        :::::       ",
"         ::::::::::::::         ",
"            ::::::::            "};


static char lowvolume[32][32] = {
"                                ",
"                                ",
"                                ",
"                                ",
"                 =              ",
"               4=40             ",
"              4=4=0             ",
"            =4=4=<0             ",
"           =4=4<<<0             ",
"         4=4=<<<<=0             ",
"        4=4<<<<4=40             ",
"  =4=4=4=<<<<=4=450             ",
"  9<<<<<<<<4=4=5550             ",
"  9<<<<<<=4=4555550             ",
"  =4=4=4=4=55555550             ",
"  55555555555555550  000   000  ",
"  55555555555555550  000   000  ",
"  55555555555555550             ",
"  55555555555555550             ",
"  55555555555555550             ",
"   0000055555555550             ",
"        05555555550             ",
"         0055555550             ",
"           05555550             ",
"            0055550             ",
"              05550             ",
"               0050             ",
"                 00             ",
"                                ",
"                                ",
"                                ",
"                                "};


static char mediumvolume[32][32] = {
"                                ",
"                                ",
"                                ",
"                                ",
"                 =              ",
"               4=40             ",
"              4=4=0             ",
"            =4=4=<0             ",
"           =4=4<<<0             ",
"         4=4=<<<<=0             ",
"        4=4<<<<4=40        000  ",
"  =4=4=4=<<<<=4=450     000000  ",
"  9<<<<<<<<4=4=5550  000000     ",
"  9<<<<<<=4=4555550  000        ",
"  =4=4=4=4=55555550             ",
"  55555555555555550  000000000  ",
"  55555555555555550  000000000  ",
"  55555555555555550             ",
"  55555555555555550  000        ",
"  55555555555555550  000000     ",
"   0000055555555550     000000  ",
"        05555555550         00  ",
"         0055555550             ",
"           05555550             ",
"            0055550             ",
"              05550             ",
"               0050             ",
"                 00             ",
"                                ",
"                                ",
"                                ",
"                                "};


static char highvolume[32][32] = {
"                                ",
"                                ",
"                                ",
"                                ",
"                 =              ",
"               4=40             ",
"              4=4=0       00    ",
"            =4=4=<0     0000    ",
"           =4=4<<<0   0000      ",
"         4=4=<<<<=0 0000        ",
"        4=4<<<<4=40 00     000  ",
"  =4=4=4=<<<<=4=450     000000  ",
"  9<<<<<<<<4=4=5550  000000     ",
"  9<<<<<<=4=4555550  000        ",
"  =4=4=4=4=55555550             ",
"  55555555555555550  000000000  ",
"  55555555555555550  000000000  ",
"  55555555555555550             ",
"  55555555555555550  000        ",
"  55555555555555550  000000     ",
"   0000055555555550     000000  ",
"        05555555550 00     000  ",
"         0055555550 0000        ",
"           05555550   0000      ",
"            0055550     0000    ",
"              05550       00    ",
"               0050             ",
"                 00             ",
"                                ",
"                                ",
"                                ",
"                                "};
