/* ownerstring.c -- view/change the owner string on a Toshiba laptop.
 *
 * Copyright (c) 1998/99  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * $Log:$
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

static const char rcsid[]="";

#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>
#ifdef __GLIBC__
#include<sys/perm.h>
#endif
#include<signal.h>
#include<paths.h>
#include<readline/readline.h>
#include<readline/history.h>

#include"sci.h"
#include"hci.h"

#define PID_FILE _PATH_VARRUN "ownerstring.pid"

#define USAGE \
"This utility can be used to set and change the owner string.\n\n\
Usage: ownerstring [-h|v]\n\
    without parameters : Display if the supervisor password is registered or\n\
                         not, and allow to register/delete it.\n\
    -u : Display the current user password mode and allow it to be changed.\n"


/*
 * Catch any signals and exit the program in nicely.
 */
void catch(int x)
{
	fprintf(stderr, "ownerstring: caught signal %d, cleaning up...\n", x);
	unlink(PID_FILE);
	exit(1);

	return;
}


/*
 * Print Incompatiable machine type and exit
 */
void Incompatible()
{
	fprintf(stderr, "ownerstring: Incompatiable machine type.\n");
	unlink(PID_FILE);
	exit(1);
}


/*
 * Read owner string into a null terminated string, return NULL on error
 */
char *GetOwnerString(void)
{
	SMMRegisters reg;
	char *owner,*string;
	long characters;
	int i,j,c,length,valid;

	/* how big is the current owner string */

	reg.eax = HCI_GET;
	reg.esi = 0x0000;
	HciFunction(&reg);
	length = (reg.ecx & 0xffff0000)>>16;
	owner = calloc(length, sizeof(char));
	if (owner==NULL)
		return NULL;

	/* read the current owner string four characters at a time */

	string = owner;
	for (i=0;i<length;i+=4) {
		reg.eax = HCI_GET;
		reg.esi = i;
		if (HciFunction(&reg)!=0x00)
			break;

		/* add non NULL characters to the string */

		valid = reg.ecx & 0xff;
		characters = reg.edx;
		for (j=0;j<4 && j<valid;j++) {
			c = (char) characters & 0xff;
			characters = characters >> 8;
		       if ((c>=0x20) && (c<=0x80))
				*(string++) = c;
			if (c==0x0d)
				*(string++) = c;

		}
	}
	*string = '\0';

	return owner;
}


/*
 * Store a new owner string.
 */
int SetOwnerString(char *owner)
{
	SMMRegisters reg;
	char string[513];
	int length,i;

	length = strlen(owner);
	printf("length=%d\n", length);

	reg.eax = HCI_SET;
	reg.ecx = 4;
	reg.esi = 0;
	reg.edx = 0x74736554;
	reg.edi = 0x54657374;
	i = HciFunction(&reg);

	printf("eax=0x%x, ecx=0x%x\n", reg.eax, reg.ecx);

	/* write zero's into the rest of the owner string */

/*	for (i=1;i<512;i+=4) {
		reg.eax = HCI_SET;
		reg.ecx = 4;
		reg.esi = i;
		reg.edx = 0x00000000;
		HciFunction(&reg);
	}*/

	return 0;
}



int main(int argc, char *argv[])
{
	FILE *str;
	int pid,help,version;
	char *owner;
	char new[]="Test owner string";


	/* this program *must* be run as root */

	if (getuid()) {
		fprintf(stderr, "ownerstring: must be run as root.\n");
		return 1;
	}


	/* process command line arguments */

 	help = 0;
	if ((--argc>0) && ((*++argv)[0]=='-'))
		switch (*++argv[0]) {
			case 'h':
				help = 1;
				break;
			default:
				printf("ownerstring: illegal option %s\n", argv[0]);
				return 1;
		}

	/* if we recieve a signal, exit cleanly */

	signal(SIGHUP, catch);
	signal(SIGINT, catch);
	signal(SIGQUIT, catch);
	signal(SIGILL, catch);
	signal(SIGTRAP, catch);
	signal(SIGABRT, catch);
	signal(SIGIOT, catch);
	signal(SIGFPE, catch);
	signal(SIGKILL, catch);
	signal(SIGSEGV, catch);
	signal(SIGPIPE, catch);
 	signal(SIGTERM, catch);
	signal(SIGCHLD, catch);
	signal(SIGCONT, catch);
	signal(SIGSTOP, catch);
	signal(SIGTSTP, catch);
	signal(SIGTTIN, catch);
	signal(SIGTTOU, catch);

	/* check to see if a copy of ownerstring is already running */

	if (!access(PID_FILE, R_OK)) {
		if ((str = fopen(PID_FILE, "r" ))) {
			fscanf(str, "%d", &pid);
			fclose(str);
			fprintf(stderr, "ownerstring: Already running as "
				"process %d.\n", pid);
			return 1;
		}
	}

	/* create the pid file */

	pid = getpid();
	if ((str = fopen(PID_FILE, "w"))) {
		fprintf(str, "%d\n", pid);
		fclose(str);
	}
	
	/* is this a supported machine? */

	if (SciSupportCheck(&version)==SCI_FAILURE)
		Incompatible();

	/* did the user request help? */

	if (help==1) {
		printf(USAGE);
		unlink(PID_FILE);
		exit(0);
	}

	owner = GetOwnerString();
	printf("%s\n", owner);

	SetOwnerString(new);

/*	add_history(new);
	owner = readline(NULL);
	printf("STRING:\n%s\n", owner);
*/

	unlink(PID_FILE);
	return 0;
}
