/* fntest.c -- testbed for new method Fn key detection
 *
 * Copyright (c) 1998,1999  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * $Log:$
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

static const char rcsid[]="$Id:$";


#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<fcntl.h>
#include<features.h>
#ifdef __GLIBC__
#include<sys/perm.h>
#endif
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/mman.h>


typedef struct {
	unsigned short ax;
	unsigned short bx;
	unsigned short cx;
	unsigned short dx;
} SMMRegisters;


enum {
	HCI_GET             = 0xfe00,
	HCI_SET             = 0xff00
};



enum {
	HCI_SYSTEM_EVENT    = 0x0016,
	HCI_HOTKEY_EVENT    = 0x001e
};

/*
 * the different states the various modes can be set to
 */
enum {
	HCI_DISABLE         = 0x0000,
	HCI_ENABLE          = 0x0001
};

/*
 * HCI error codes
 */
enum {
	HCI_SUCCESS         = 0x00,
	HCI_FAILURE         = 0x01,
	HCI_NOT_SUPPORTED   = 0x80,
	HCI_INPUT_ERROR     = 0x83,
	HCI_WRITE_PROTECTED = 0x84,
	HCI_FIFO_EMPTY      = 0x8c
};


int HciFnStatus(void)
{
	unsigned char al;

	asm ("cli\n\t" \
		"movw $0x008e,%%ax\n\t" \
		"outb %%al,$0xe4\n\t" \
		"inb $0xe5,%%al\n\t" \
		"movb %%al,%0\n\t" \
		"sti\n"
		:"=m" (al) : : "memory" );

	return (int) al;
}


int HciFunction(SMMRegisters *reg)
{
	unsigned short ax,bx,cx,dx;

	ax = reg->ax;
	bx = reg->bx;
	cx = reg->cx;
	dx = reg->dx;

	asm ("inb $0xb2,%%al\n" \
		:"=ax" (ax), "=bx" (bx), "=cx" (cx), "=dx" (dx) \
		:"ax" (ax), "bx" (bx), "cx" (cx), "dx" (dx) \
		: "memory" );

	reg->ax = ax;
	reg->bx = bx;
	reg->cx = cx;
	reg->dx = dx;

	return (int) (ax & 0xff00)>>8;
}


int main(int argc, char *argv[])
{
	SMMRegisters reg;
	int acpi;
	unsigned short lastevent = 0x0100;

	if (iopl(3)) {
		printf("fntest: can't get I/O permissions.\n");
		exit (1);
	}

	acpi = 0;
	reg.ax = HCI_GET;
	reg.bx = HCI_HOTKEY_EVENT;
	reg.cx = 0;
	if (HciFunction(&reg)==HCI_SUCCESS) {
		acpi = 1;
		printf("ACPI enabled laptop\n");
		reg.ax = HCI_SET;
		reg.bx = HCI_SYSTEM_EVENT;
		reg.cx = HCI_ENABLE;
		HciFunction(&reg);
		printf("System Event FIFO enabled\n");
		reg.ax = HCI_SET;
		reg.bx = HCI_HOTKEY_EVENT;
		reg.cx = HCI_ENABLE;
		HciFunction(&reg);
		printf("Hotkey event reporting enabled\n");
	}
	
	for(;;) {

		usleep(200000);

		reg.ax = HCI_GET;
		reg.bx = HCI_SYSTEM_EVENT;
		reg.cx = lastevent;
		if (HciFunction(&reg)==HCI_SUCCESS) {
			printf("\nSYSTEM_EVENT: 0x%04x\n", reg.cx);
		} else {
			printf("#");
		}
		lastevent = reg.cx;


	}

	return 0;
}


