/* wmtuxtime.c -- WindowMaker dockable applet portion of TuxTime
 *
 * Copyright (c) 1997-99  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * $Log:$
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#define DELAY 10000L
#define PID_FILE "wmtuxtime.pid"
#define MINUTES(h,m) ((h*60)+m)

enum {
        NEVER   = 0x00,
        TIME    = 0x01,
        PERCENT = 0x02,
        BOTH    = 0x03
};

enum {
	NORMAL    = 0x1000,
        LOW       = 0x2000,
        CRITICAL  = 0x4000,
	EMERGENCY = 0X8000
};

typedef struct {
        int hour;
        int minute;
        int percent;
        int trigger;
} BatteryState;


#define TIME_BATTERY_ALERT \
"Your computer\\047s battery power is low.\\n\
You have approximately %d minutes\\n\
left on this battery"

#define PERCENT_BATTERY_ALERT \
"Your computer\\047s battery power is low.\\n\
Only %d%% of total battery capacity\\n\
remains"

#define EMERGENCY_BATTERY_ALERT \
"You have almost no battery\\n\
capacity left on this battery!\\n\
Find an alternative power source\\n\
immediately!"



