/* sci.c -- System Configuration Interface
 *
 * Copyright (c) 1998/99  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
 *
 *   This code is covered by the GNU GPL and you are free to make any
 *   changes you wish to it under the terms of the license. However the
 *   code has the potential to render your computer and/or someone else's
 *   unuseable. Unless you truely understand what is going on, I urge you
 *   not to make any modifications and use it as it stands.
 *   
 * $Log: sci.c,v $
 * Revision 1.12  1999/11/17 16:00:42  jab
 * changed assembler to manually save registers, hopefully this should
 * make the programs more stable
 *
 * Revision 1.11  1999/07/25 14:39:49  jab
 * fixed bugs in SciOpenInterface and SciSetPassword
 * updated email address
 *
 * Revision 1.10  1999/03/11 20:22:14  jab
 * changed get and set routines to use SciRegisters
 *
 * Revision 1.9  1999/03/06 16:46:30  jab
 * moved the BiosVersion and MachineID functions to hci.c
 *
 * Revision 1.8  1998/09/07 18:23:36  jab
 * removed SciGetMachineID2 as no longer required
 * added a routine to extract the model string from the BIOS
 *
 * Revision 1.7  1998/09/04 18:14:31  jab
 * fixed the compile warning about rcsid
 *
 * Revision 1.6  1998/08/24 18:05:04  jab
 * implemented the SciGetBiosVersion function
 *
 * Revision 1.5  1998/08/23 12:16:45  jab
 * fixed the SciACPower function so it now works
 *
 * Revision 1.4  1998/08/19 08:45:10  jab
 * changed GetMachineId to return SCI_SUCCESS/SCI_FAILURE
 *
 * Revision 1.3  1998/08/18 16:54:54  jab
 * fixes to SciGetMachineId curtesy of Patrick Reyonlds <patrick@cs.virgina.edu>
 *
 * Revision 1.2  1998/08/06 08:27:14  jab
 * prepended all functions with Sci
 *
 * Revision 1.1  1998/05/23 08:08:53  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 */

static const char rcsid[]="$Id: sci.c,v 1.12 1999/11/17 16:00:42 jab Exp jab $";

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/mman.h>

#include"sci.h"


/*
 * Is this a supported Machine? (ie. is it a Toshiba)
 */
int SciSupportCheck(int *version)
{
	unsigned short dx;
	unsigned char ah;

	asm ("pushl %%eax\n\t" \
		"pushl %%ebx\n\t" \
		"pushl %%ecx\n\t" \
		"movw $0xf0f0,%%ax\n\t" \
		"movw $0x0000,%%bx\n\t" \
		"movw $0x0000,%%cx\n\t" \
		"inb $0xb2,%%al\n\t" \
		"popl %%ecx\n\t" \
		"popl %%ebx\n\t" \
		"popl %%eax\n" \
		:"=dx" (dx), "=ah" (ah) : : "memory" );

	*version = (int) dx;

	return (int) (ah & 0xff);
}


/*
 * Open an interface to the Toshiba hardware.
 *
 *   Note: Set and Get will not work unless an interface has been opened.
 */
int SciOpenInterface(void)
{
	unsigned char ah;

	asm ("pushl %%eax\n\t" \
		"pushl %%ebx\n\t" \
		"pushl %%ecx\n\t" \
		"movw $0xf1f1,%%ax\n\t" \
		"movw $0x0000,%%bx\n\t" \
		"movw $0x0000,%%cx\n\t" \
		"inb $0xb2,%%al\n\t" \
		"movb %%ah,%0\n\t" \
		"popl %%ecx\n\t" \
		"popl %%ebx\n\t" \
		"popl %%eax\n" \
		:"=m" (ah) : : "memory" );

	return (int) ah;
}


/*
 * Close any open interface to the hardware
 */
int SciCloseInterface(void)
{
	unsigned char ah;

	asm ("pushl %%eax\n\t" \
		"pushl %%ebx\n\t" \
		"pushl %%ecx\n\t" \
		"movw $0xf2f2,%%ax\n\t" \
		"movw $0x0000,%%bx\n\t" \
		"movw $0x0000,%%cx\n\t" \
		"inb $0xb2,%%al\n\t" \
		"popl %%ecx\n\t" \
		"popl %%ebx\n\t" \
		"popl %%eax\n" \
		:"=ah" (ah) : : "memory" );

	return (int) (ah & 0xff);
}


/*
 * Get the setting of a given mode of the laptop
 */
int SciGet(SciRegisters *reg)
{
	unsigned short ax,bx,cx,dx;

	ax = 0;
	bx = reg->setting;
	cx = reg->current;
	dx = reg->possible;

	asm ("pushl %%esi\n\t" \
		"pushl %%edi\n\t" \
		"movw $0xf3f3,%%ax\n\t" \
		"inb $0xb2,%%al\n\t" \
		"popl %%edi\n\t" \
		"popl %%esi\n" \
		:"=ax" (ax), "=bx" (bx), "=cx" (cx), "=dx" (dx) \
		:"bx" (bx), "cx" (cx) \
		: "memory" );

	if (reg->setting==0x0101) {
		printf("BATTERY SAVE error=0x%04x type=0x%04x setting=0x%04x\n",
			ax, bx, cx);
	}

	if (reg->setting==0x8300) {
		printf("DISP MODE error=0x%04x type=0x%04x setting=0x%04x\n",
			ax, bx, cx);
	}

	reg->attribute = (ax & 0xff);
	reg->setting = bx;
	reg->current = cx;
	reg->possible = dx;

	return (int) (ax & 0xff00)>>8;
}



/*
 * Set the setting of a given mode of the laptop
 */
int SciSet(SciRegisters *reg)
{
	unsigned short ax,bx,cx,dx;

	ax = 0;
	bx = reg->setting;
	cx = reg->current;
	dx = reg->possible;

	asm ("pushl %%esi\n\t" \
		"pushl %%edi\n\t" \
		"movw $0xf4f4,%%ax\n\t" \
		"inb $0xb2,%%al\n\t" \
		"popl %%edi\n\t" \
		"popl %%esi\n" \
		:"=ax" (ax) \
		:"bx" (bx), "cx" (cx), "dx" (dx) \
		: "memory" );

	reg->attribute = (ax & 0xff);

	return (int) (ax & 0xff00)>>8;
}


/*
 * Get the status of the AC Power on a Toshiba laptop.
 */
int SciACPower(void)
{
	unsigned short cx;
	unsigned char fl;

	asm ("pushl %%eax\n\t" \
		"pushl %%ebx\n\t" \
		"pushl %%ecx\n\t" \
		"movw $0xfe00,%%ax\n\t" \
		"movw $0x0003,%%bx\n\t" \
		"movw $0x0000,%%cx\n\t" \
		"movw $0x0000,%%dx\n\t" \
		"inb $0xb2,%%al\n\t" \
		"lahf\n\t" \
		"movw %%cx,%0\n\t" \
		"movb %%ah,%1\n\t" \
		"popl %%ecx\n\t" \
		"popl %%ebx\n\t" \
		"popl %%eax\n" \
		:"=m" (cx), "=m" (fl) \
		: \
		: "memory" );

	if ((fl & 0x01)==0)
		return (int) cx;
	else
		return 0;
}


/*
 * My own concoction that will hopefully provide extra identification
 * information.
 *
 *   The function will fill the minimum eight character array passed to it
 *   with the model as a null terminated string. So for example on my
 *   Libretto 50CT it will return "50CT\0", on my Satellite Pro 400CS it
 *   will return "400CS\0".
 *
 */
int SciGetModel(char *model)
{
	int device,loop;
	unsigned char *mem;


	if ((device = open("/dev/mem", O_RDWR))==-1)
		return SCI_FAILURE;

	mem = mmap(0, 0x1000, PROT_READ, MAP_SHARED, device, 0xfe000);
	if (mem==(unsigned char *)-1)
		return SCI_FAILURE;


	for (loop=0;loop<7 && mem[loop]!=0x20;loop++)
		model[loop] = mem[loop];
	model[loop] = 0x00;

	munmap(mem, 0x1000);
	close(device);

	return SCI_SUCCESS;
}


/*
 * Set a supervisor or user password for the laptop.
 *
 *   To remove a password, call this routine with the *same* password.
 *   In theory this should be done via the Set routine.
 *
 */
int SciSetPassword(char *password, unsigned short type, int *trys)
{
	unsigned char ah;
	unsigned short di,dx;
	unsigned int edx,esi;

	edx = *(password+3) + *(password+2)*0x100 + *(password+1)*0x10000 +
	        *(password)*0x1000000;
	esi = *(password+7) + *(password+6)*0x100 + *(password+5)*0x10000 +
	        *(password+4)*0x1000000;
	di = *(password+9) + *(password+8)*0x100;

	asm ("movw $0xf4f4,%%ax\n\t" \
		"movw $0x0602,%%bx\n\t" \
		"movw %2,%%cx\n\t" \
		"movl %3,%%edx\n\t" \
		"movl %4,%%esi\n\t" \
		"movw %5,%%di\n\t" \
		"inb $0xb2,%%al\n\t" \
		"movw %%dx,%0\n\t" \
		"movb %%ah,%1\n"
		:"=m" (dx), "=m" (ah) \
		:"m" (type), "m" (edx), "m" (esi), "m" (di) \
		: "memory" );

	*trys = (int) dx;

	return (int) ah;
}
