/* leds.h -- X11 bitmaps of LED digits for TuxTime
 *
 * Copyright (c) 1998  Jonathan A. Buzzard (jab@hex.prestel.co.uk)
 *
 * $Log: leds.h,v $
 * Revision 1.1  1998/08/09 09:08:35  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * "$Id: leds.h,v 1.1 1998/08/09 09:08:35 jab Exp jab $"
 *
 */

#ifndef LEDS_H
#define LEDS_H

#define zero_width 10
#define zero_height 15
static char zero_bits[] = {
 0x00,0x00,0xfc,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x00,
 0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0xfc,0x00,0x00,0x00
 };

#define one_width 10
#define one_height 15
static char one_bits[] = {
 0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,
 0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00
 };

#define two_width 10
#define two_height 15
static char two_bits[] = {
 0x00,0x00,0xfc,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xfc,
 0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xfc,0x00,0x00,0x00
 };

#define three_width 10
#define three_height 15
static char three_bits[] = {
 0x00,0x00,0xfc,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xfc,
 0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xfc,0x00,0x00,0x00
 };

#define four_width 10
#define four_height 15
static char four_bits[] = {
 0x00,0x00,0x00,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0xfc,
 0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00
 };

#define five_width 10
#define five_height 15
static char five_bits[] = {
 0x00,0x00,0xfc,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xfc,
 0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xfc,0x00,0x00,0x00
 };

#define six_width 10
#define six_height 15
static char six_bits[] = {
 0x00,0x00,0xfc,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0x02,0x00,0xfc,
 0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0xfc,0x00,0x00,0x00
 };

#define seven_width 10
#define seven_height 15
static char seven_bits[] = {
 0x00,0x00,0xfc,0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,
 0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x00,0x00,0x00
 };

#define eight_width 10
#define eight_height 15
static char eight_bits[] = {
 0x00,0x00,0xfc,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0xfc,
 0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0xfc,0x00,0x00,0x00
 };

#define nine_width 10
#define nine_height 15
static char nine_bits[] = {
 0x00,0x00,0xfc,0x00,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0x02,0x01,0xfc,
 0x00,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0x00,0x01,0xfc,0x00,0x00,0x00
 };

#define percent_width 10
#define percent_height 15
static char percent_bits[] = {
 0x00,0x00,0x00,0x00,0x1c,0x00,0x22,0x00,0x22,0x01,0xa2,0x00,0x5c,0x00,0x20,
 0x00,0x10,0x00,0xe8,0x00,0x14,0x01,0x12,0x01,0x10,0x01,0xe0,0x00,0x00,0x00
 };

#define colon_width 5
#define colon_height 15
static unsigned char colon_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x0c, 0x0c, 0x00, 0x00, 0x00, 0x0c, 0x0c,
   0x00, 0x00, 0x00};

#endif
