/* hci.c -- Hardware Configuration Interface
 *
 * Copyright (c) 1998/99  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING WARNING
 *
 *   This code is covered by the GNU GPL and you are free to make any
 *   changes you wish to it under the terms of the license. However the
 *   code has the potential to render your computer and/or someone else's
 *   unuseable. Unless you truely understand what is going on, I urge you
 *   not to make any modifications and use it as it stands.
 *   
 * $Log: hci.c,v $
 * Revision 1.2  1999/08/15 10:43:28  jab
 * removed the HciGet and HciSet and replaced with HciFunction
 *
 * Revision 1.1  1999/03/11 20:27:06  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 */

static const char rcsid[]="$Id: hci.c,v 1.2 1999/08/15 10:43:28 jab Exp jab $";

#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<fcntl.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<sys/mman.h>

#include"hci.h"


static int id=0xfc2f;

int HciFunction(HciRegisters *reg)
{
	unsigned short ax,bx,cx,dx;

	ax = reg->ax;
	bx = reg->bx;
	cx = reg->cx;
	dx = reg->dx;

	/* emulate the HCI fan function for the Portage 610 and Tecra 700 */

	if ((id==0xfccb) && (bx==HCI_FAN)) {
		asm("movw %1,%%ax\n\t" \
			"movw %2,%%cx\n\t" \
			"cli\n\t" \
			"movb $0xbe,%%al\n\t" \
			"outb %%al,$0xe4\n\t" \
			"inb $0xe5,%%al\n\t" \
			"cmpb $0xfe,%%ah\n\t" \
			"je 3f\n\t" \
			"cmpw $0x0001,%%cx\n\t" \
			"jne 1f\n\t" \
			"andb $0xfe,%%al\n\t" \
			"jmp 2f\n\t" \
			"1: orb $0x01,%%al\n\t" \
			"2: movb %%al,%%ah\n\t" \
			"movb $0xbe,%%al\n\t" \
			"outb %%al,$0xe4\n\t" \
			"movb %%ah,%%al\n\t" \
			"outb %%al,$0xe5\n\t" \
			"3: sti\n\t" \
			"andw $0x0001,%%ax\n\t" \
			"movw %%ax,%0\n" \
 			:"=m" (cx) : "m" (ax), "m" (cx) : "memory" );
		cx = (cx==0x00) ? 0x01:0x00;
		ax = 0x0000;
	} else if ((id==0xfccb) && (bx==HCI_FAN)) {
		asm("movw %1,%%ax\n\t" \
			"movw %2,%%cx\n\t" \
			"cli\n\t" \
			"movw $0x00e4,%%dx\n\t" \
			"movb $0xe0,%%al\n\t" \
			"outb %%al,%%dx\n\t" \
			"incw %%dx\n\t" \
			"inb %%dx,%%al\n\t" \
			"cmpb $0xfe,%%ah\n\t" \
			"je 3f\n\t" \
			"cmpw $0x0001,%%cx\n\t" \
			"jne 1f\n\t" \
			"orw $0x0001,%%ax\n\t" \
			"jmp 2f\n\t" \
			"1: andw $0xfffe,%%ax\n\t" \
			"2: decw %%dx\n\t" \
			"movb %%al,%%ah\n\t" \
			"movb $0xe0,%%al\n\t" \
			"outw %%ax,%%dx\n\t" \
			"3: sti\n\t" \
			"andw $0x0001,%%ax\n\t" \
			"movw %%ax,%0\n" \
 			:"=m" (cx) : "m" (ax), "m" (cx) : "memory" );
		ax = 0x0000;		
	} else {
		asm ("inb $0xb2,%%al\n" \
			:"=ax" (ax), "=bx" (bx), "=cx" (cx), "=dx" (dx) \
			:"ax" (ax), "bx" (bx), "cx" (cx), "dx" (dx) \
			: "memory" );
	}
	

	reg->ax = ax;
	reg->bx = bx;
	reg->cx = cx;
	reg->dx = dx;

	return (int) (ax & 0xff00)>>8;
}


/*
 * Return the BIOS version of the laptop
 *
 *   I may or may not follow the Toshiba version of this function. The
 *   Toshiba function would appear to read from this area of memory, but
 *   exactly what it does I am not sure. This implemenation is impirically
 *   based on the contents of these memory locations on my Satellite Pro
 *   400CS and Libretto 50CT. I have confirmed that it returns the correct
 *   information on a Tecra 750CDT and a T4900 as well.
 */
int HciGetBiosVersion(void)
{
	int device,major,minor;
	unsigned char *mem;


	if ((device = open("/dev/mem", O_RDWR))==-1)
		return HCI_FAILURE;

	mem = mmap(0, 0x1000, PROT_READ, MAP_SHARED, device, 0xfe000);
	if (mem==(unsigned char *)-1)
		return HCI_FAILURE;

	major = (char) mem[0x0009]-'0';
	minor = (((char) mem[0x000b]-'0')*10)+((char) mem[0x000c]-'0');

	munmap(mem, 0x1000);
	close(device);

	id = (major*0x100)+minor;

	return id;
}


/*
 * Get the Toshiba machine identification number
 *
 *     0xfc2f: New style Machine ID
 *     0xfcc3: Tecra 720x
 *     0xfcca: Satellite Pro 400x
 *     0xfccb: Portage 610CT
 *     0xfccc: Tecra 700x
 *     0xfcdd: Satellite 110x
 *     0xfcd7: Satellite Pro 430x
 *     0xfcdf: Tecra 500x
 */
int HciGetMachineID(int *id)
{
	int device;
	unsigned char *mem;
	unsigned short bx;
	unsigned char fl;

	if ((device = open("/dev/mem", O_RDWR))==-1)
		return HCI_FAILURE;

	mem = mmap(0, 0x1000, PROT_READ, MAP_SHARED, device, 0xff000);
	if (mem==(unsigned char *)-1)
		return HCI_FAILURE;

	if (((int) mem[0xffa])!=0x2e) {
		*id = (0x100*((int) mem[0xffe]))+((int) mem[0xffa]);
	}
	else {
		/* I hope the person resonsible for this mess has been sacked */

		/* start by getting a pointer into the BIOS */

		asm ("movw $0xc000,%%ax\n\t" \
			"movw $0x0000,%%bx\n\t" \
			"movw $0x0000,%%cx\n\t" \
			"movl $0x00000000,%%edx\n\t" \
			"inb $0xb2,%%al\n\t" \
			"movw %%bx,%0\n\t" \
			"lahf\n\t" \
			"movb %%ah,%1\n"
			:"=m" (bx), "=m" (fl) \
			: \
			: "memory" );

		/* twiddle with our pointer a bit */

		*id = 0xfc2f;
	}

	munmap(mem, 0x1000);
	close(device);


	return HCI_SUCCESS;
}


/*
 * Return the LCD Panel type
 *
 */
int HciGetLCDPanelType(unsigned short mode, unsigned short *status)
{
	unsigned short ax,bx,cx;
	unsigned char fl;

	bx = mode;
	cx = *status;
	
	asm ("movw $0xfefe,%%ax\n\t" \
		"movw $0x0011,%%bx\n\t" \
		"inb $0xb2,%%al\n\t" \
		"movw %%ax,%0\n\t" \
		"movw %%bx,%1\n\t" \
		"movw %%cx,%2\n\t" \
		"lahf\n\t" \
		"movb %%ah,%3\n"
		:"=m" (ax), "=m" (bx), "=m" (cx), "=m" (fl) \
		:"m" (bx), "m" (cx) \
		: "memory" );

	*status = cx;

	return (int) (fl & 0x01);
}


/*
 * Return the status of the Fn key
 */
int HciFnStatus(void)
{
        unsigned char al;

        asm ("cli\n\t" \
                "movw $0x008e,%%ax\n\t" \
                "outb %%al,$0xe4\n\t" \
                "inb $0xe5,%%al\n\t" \
                "movb %%al,%0\n\t" \
                "sti\n"
                :"=m" (al) : : "memory" );

        return (int) al;
}
