/* display.c -- display settings dialog for TuxTime
 *
 * Copyright (c) 1996-98  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * $Log: display.c,v $
 * Revision 1.1  1999/06/22 22:56:39  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

static const char rcsid[]="$Id: display.c,v 1.1 1999/06/22 22:56:39 jab Exp jab $";


#include<stdio.h>
#include<stdlib.h>
#include<gtk/gtk.h>

#include"sci.h"
#include"misc.h"
#include"config.h"


static GtkWidget *bargraph,*percent,*timeremain;
static GtkWidget *stack,*cycle,*manual,*automatic,*cycletime;
static GtkWidget *small,*medium,*large,*left,*right,*drag;
static GtkWidget *normal,*ontop,*ontitle,*regular,*mini,*none;
static GtkWidget *twostyle,*twomodules,*twosize;
static GtkAdjustment *spinner;

static int modules,size,style;

enum {
	BARGRAPH = 0x01,
	PERCENT  = 0x02,
	TIME     = 0x04
};

enum {
	SMALL  = 0x01,
	MEDIUM = 0x02,
	LARGE  = 0x03
};

enum {
	NORMAL     = 0x01,
	ON_TOP     = 0x02,
	TITLE_BAR  = 0x04,
	MENU_BAR   = 0x08
};


void SetStyleRadioButtons(int setting)
{
	printf("FIXME: need to set style radio buttons\n");
	
	return;
}



void SetModuleCheckButtons(int setting)
{
	if ((setting & BARGRAPH)!=0x00)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bargraph), TRUE);
	else
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(bargraph), FALSE);

	if ((setting & PERCENT)!=0x00)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(percent), TRUE);
	else
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(percent), FALSE);

	if ((setting & TIME)!=0x00)
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(timeremain), TRUE); 
	else
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(timeremain), FALSE); 

	return;
}


void SetSizeRadioButtons(int setting)
{
	switch (setting) {
		case SMALL:
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(small),
				TRUE);
			break;
		case MEDIUM:
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(medium),
				TRUE);
			break;
		case LARGE:
			gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(large),
				TRUE);
			break;
	}
	return;
}


void TwoBatteriesCallback(GtkWidget *widget, gpointer data)
{
	if (GTK_TOGGLE_BUTTON(widget)->active) {
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(twostyle), TRUE);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(twosize), TRUE);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(twomodules),
			TRUE);
	} else {
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(twostyle), FALSE);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(twosize), FALSE);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(twomodules),
			FALSE);
	}

	return;
}


void StyleWindowCallback(GtkWidget *widget, gpointer data)
{
	style = (int) data;

	return;
}


void StyleShowingCallback(GtkWidget *widget, gpointer data)
{
	style = (int) data;

	return;
}


/*
 * Update the stored setting of the module state and make sure at least one
 * is always checked
 */
void ModuleCallback(GtkWidget *widget, gpointer data)
{
	if (((int) data) != modules)
		modules ^= (int) data;
	else
		SetModuleCheckButtons(modules);

	return;
}

void ModulesFormatCallback(GtkWidget *widget, gpointer data)
{
	return;
}


void SizeCallback(GtkWidget *widget, gpointer data)
{
	size = (int) data;

	return;
}


/*
 * Return the settings to their default values
 */
void SetDisplayDefaultsCallback(GtkWidget *widget, gpointer *data)
{
	modules = 3;
	SetModuleCheckButtons(modules);

	size = 1;
	SetSizeRadioButtons(size);

	style = 1;

	return;
}


/*
 * Save the display settings to the configuration file
 */
void SaveDisplaySettingsCallback(GtkWidget *widget, gpointer *data)
{
	char buffer[16];

	sprintf(buffer, "%d", style);
	WriteConfigString("Display", "Style", buffer, config);
	sprintf(buffer, "%d", modules);
	WriteConfigString("Display", "Modules", buffer, config);
	sprintf(buffer, "%d", size);
	WriteConfigString("Display", "Size", buffer, config);

	gtk_widget_destroy(GTK_WIDGET(data));

	return;
}


/*
 * Build the Display Modules pages of the notebook
 */
void AddStylePage(GtkWidget *notebook, GtkWidget *window)
{
	GtkWidget *box,*frame,*column,*layout,*row,*two;
	GtkWidget *label,*buttons;
	GSList *list;


	box = gtk_hbox_new(FALSE, 0);

	/* add the show all battery status check button */

	two = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), two, TRUE, TRUE, 0);
	twostyle =
		gtk_check_button_new_with_label("Show All Batteries' Status");
	gtk_box_pack_start(GTK_BOX(two), twostyle, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(twostyle), "released",
		GTK_SIGNAL_FUNC(TwoBatteriesCallback), (gpointer) 1);

	/* add main frame for the page */

	frame = gtk_frame_new("Display Style");
	gtk_container_border_width(GTK_CONTAINER(frame), 4);
	gtk_box_pack_start(GTK_BOX(two), frame, TRUE, TRUE, 0);

	buttons = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(buttons), 4);
	gtk_box_pack_start(GTK_BOX(box), buttons, FALSE, FALSE, 4);

	AddButtons(buttons, window, BUTTONS_DISPLAY);

	/* box for laying out the frames */

	column = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(column), 4);
	gtk_container_add(GTK_CONTAINER(frame), column);
	row = gtk_hbox_new(FALSE,4);
	gtk_container_border_width(GTK_CONTAINER(row), 4);
	gtk_box_pack_start(GTK_BOX(column), row, TRUE, TRUE, 0);

	/* window behaviour frame */

	frame = gtk_frame_new("Window Behaviour");
	gtk_container_border_width(GTK_CONTAINER(frame), 4);
	gtk_box_pack_start(GTK_BOX(row), frame, TRUE, TRUE, 0);

	layout = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(layout), 4);
	gtk_container_add(GTK_CONTAINER(frame), layout);

	normal = gtk_radio_button_new_with_label(NULL, "Normal");
	gtk_box_pack_start(GTK_BOX(layout), normal, FALSE, FALSE, 0);
	list = gtk_radio_button_group(GTK_RADIO_BUTTON(normal));
	gtk_signal_connect(GTK_OBJECT(normal), "pressed",
		GTK_SIGNAL_FUNC(StyleWindowCallback), (gpointer) 1);

	ontop = gtk_radio_button_new_with_label(list, "Always on Top");
	gtk_box_pack_start(GTK_BOX(layout), ontop, FALSE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(ontop), "pressed",
		GTK_SIGNAL_FUNC(StyleWindowCallback), (gpointer) 2);

	ontitle = gtk_radio_button_new_with_label(list, "On Title Bar");
	gtk_box_pack_start(GTK_BOX(layout), ontitle, FALSE, TRUE, 0);


	/* showing frame */

	frame = gtk_frame_new("Title Bar Style");
	gtk_container_border_width(GTK_CONTAINER(frame), 4);
	gtk_box_pack_start(GTK_BOX(row), frame, FALSE, FALSE, 0);

	layout = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(layout), 4);
	gtk_container_add(GTK_CONTAINER(frame), layout);

	regular = gtk_radio_button_new_with_label(NULL, "Regular");
	list = gtk_radio_button_group(GTK_RADIO_BUTTON(regular));
	gtk_box_pack_start(GTK_BOX(layout), regular, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(regular), "released",
		GTK_SIGNAL_FUNC(StyleShowingCallback), (gpointer) 1);

	mini = gtk_radio_button_new_with_label(list, "Mini");
	gtk_box_pack_start(GTK_BOX(layout), mini, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(mini), "released",
		GTK_SIGNAL_FUNC(StyleShowingCallback), (gpointer) 2);

	none = gtk_radio_button_new_with_label(list, "None");
	gtk_box_pack_start(GTK_BOX(layout), none, FALSE, FALSE, 2);


	/* title bar options */

	frame = gtk_frame_new("\"On Title Bar\" Options");
	gtk_container_border_width(GTK_CONTAINER(frame), 4);
	gtk_box_pack_start(GTK_BOX(column), frame, FALSE, FALSE, 0);

	layout = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(layout), 4);
	gtk_container_add(GTK_CONTAINER(frame), layout);

	left = gtk_radio_button_new_with_label(NULL, "Always Left Justified");
	gtk_box_pack_start(GTK_BOX(layout), left, FALSE, FALSE, 0);
	list = gtk_radio_button_group(GTK_RADIO_BUTTON(left));

	right = gtk_radio_button_new_with_label(list, "Always Right Justified");
	gtk_box_pack_start(GTK_BOX(layout), right, FALSE, TRUE, 0);

	drag = gtk_radio_button_new_with_label(list,
		"Custom Placement - Drag To Position");
	gtk_box_pack_start(GTK_BOX(layout), drag, FALSE, TRUE, 0);


	/* get the setting from the configuration file */

	style = GetConfigInt("Display", "Style", 3, config);
	SetStyleRadioButtons(style);

	label = gtk_label_new("Style");	
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box, label);

	return;
}


/*
 * Build the Display Modules pages of the notebook
 */
void AddModulesPage(GtkWidget *notebook, GtkWidget *window)
{
	GtkWidget *box,*two,*frame,*column,*rows,*layout;
	GtkWidget *label,*buttons,*space;
	GSList *group;


	box = gtk_hbox_new(FALSE, 0);

	/* add the show all battery status check button */

	two = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), two, TRUE, TRUE, 0);
	twomodules =
		gtk_check_button_new_with_label("Show All Batteries' Status");
	gtk_box_pack_start(GTK_BOX(two), twomodules, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(twomodules), "released",
		GTK_SIGNAL_FUNC(TwoBatteriesCallback), (gpointer) 2);

	/* add main frame for the page */

	frame = gtk_frame_new("Display Modules");
	gtk_container_border_width(GTK_CONTAINER(frame), 4);
	gtk_box_pack_start(GTK_BOX(two), frame, TRUE, TRUE, 0);

	buttons = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(buttons), 4);
	gtk_box_pack_start(GTK_BOX(box), buttons, FALSE, TRUE, 4);

	AddButtons(buttons, window, BUTTONS_DISPLAY);

	rows = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(rows), 4);
	gtk_container_add(GTK_CONTAINER(frame), rows);

	/* add the check buttons for the different modules */

	frame = gtk_frame_new("Show");
	gtk_container_border_width(GTK_CONTAINER(frame), 4);
	gtk_box_pack_start(GTK_BOX(rows), frame, TRUE, TRUE, 0);

	column = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(column), 4);
	gtk_container_add(GTK_CONTAINER(frame), column);

	bargraph = gtk_check_button_new_with_label("Bargraph");
	gtk_box_pack_start(GTK_BOX(column), bargraph, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(bargraph), "released",
		GTK_SIGNAL_FUNC(ModuleCallback), (gpointer) BARGRAPH);

	percent = gtk_check_button_new_with_label("Percent Remaining");
	gtk_box_pack_start(GTK_BOX(column), percent, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(percent), "released",
		GTK_SIGNAL_FUNC(ModuleCallback), (gpointer) PERCENT);

	timeremain = gtk_check_button_new_with_label("Time Remaining");
	gtk_box_pack_start(GTK_BOX(column), timeremain, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(timeremain), "released",
		GTK_SIGNAL_FUNC(ModuleCallback), (gpointer) TIME);

	/* add the check buttons for the display format of the modules */

	frame = gtk_frame_new("Format");
	gtk_container_border_width(GTK_CONTAINER(frame), 4);
	gtk_box_pack_start(GTK_BOX(rows), frame, TRUE, TRUE, 0);

	column = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(column), 4);
	gtk_container_add(GTK_CONTAINER(frame), column);

	/* now pack the box with radio buttons */

	stack = gtk_radio_button_new_with_label(NULL, "Stack Modules");
	gtk_box_pack_start(GTK_BOX(column), stack, FALSE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(stack));
	gtk_signal_connect(GTK_OBJECT(stack), "pressed",
		GTK_SIGNAL_FUNC(ModulesFormatCallback), (gpointer) 1);

	cycle = gtk_radio_button_new_with_label(group, "Cycle Modules");
	gtk_box_pack_start(GTK_BOX(column), cycle, FALSE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(cycle), "pressed",
		GTK_SIGNAL_FUNC(ModulesFormatCallback), (gpointer) 2);

	/* check buttons for the cycle options */

	layout = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(column), layout, FALSE, TRUE, 0);

	space = gtk_label_new("    ");	
	gtk_box_pack_start(GTK_BOX(layout), space, FALSE, TRUE, 0);

	manual = gtk_check_button_new_with_label("Show Manual Control Button");
	gtk_box_pack_start(GTK_BOX(layout), manual, FALSE, FALSE, 0);
/*	gtk_signal_connect(GTK_OBJECT(timeremain), "released",
		GTK_SIGNAL_FUNC(ModuleCallback), (gpointer) TIME);
*/
	layout = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(column), layout, FALSE, TRUE, 0);
	space = gtk_label_new("    ");	
	gtk_box_pack_start(GTK_BOX(layout), space, FALSE, TRUE, 0);

	automatic = gtk_check_button_new_with_label(
		"Auto Cycle Every");
	gtk_box_pack_start(GTK_BOX(layout), automatic, FALSE, FALSE, 0);

	spinner = (GtkAdjustment *) gtk_adjustment_new(4, 1, 5, 1, 1, 1);
	cycletime = gtk_spin_button_new(spinner, 0, 0);
	gtk_box_pack_start(GTK_BOX(layout), cycletime, FALSE, FALSE, 0);

	label = gtk_label_new("Seconds");
	gtk_box_pack_start(GTK_BOX(layout), label, FALSE, TRUE, 0);

	/* get the setting from the configuration file */

	modules = GetConfigInt("Display", "Modules", 3, config);
	SetModuleCheckButtons(modules);

	label = gtk_label_new("Modules");	
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box, label);

	return;
}


/*
 * Build the Display Size page of the notebook
 */
void AddSizePage(GtkWidget *notebook, GtkWidget *window)
{
	GtkWidget *box,*frame,*column,*two;
	GtkWidget *label,*buttons;
	GSList *group;


	box = gtk_hbox_new(FALSE, 0);

	/* add the show all battery status check button */

	two = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(box), two, TRUE, TRUE, 0);
	twosize = gtk_check_button_new_with_label("Show All Batteries' Status");
	gtk_box_pack_start(GTK_BOX(two), twosize, FALSE, FALSE, 2);
	gtk_signal_connect(GTK_OBJECT(twosize), "released",
		GTK_SIGNAL_FUNC(TwoBatteriesCallback), (gpointer) 3);

	/* add main frame for the page */

	frame = gtk_frame_new("Display Size");
	gtk_container_border_width(GTK_CONTAINER(frame), 4);
	gtk_box_pack_start(GTK_BOX(two), frame, TRUE, TRUE, 0);

	buttons = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(buttons), 4);
	gtk_box_pack_start(GTK_BOX(box), buttons, FALSE, TRUE, 4);

	AddButtons(buttons, window, BUTTONS_DISPLAY);

	/* vertical box for the radio buttons */

	column = gtk_vbox_new(FALSE, 4);
	gtk_container_border_width(GTK_CONTAINER(column), 4);
	gtk_container_add(GTK_CONTAINER(frame), column);

	/* now pack the box with check buttons */

	small = gtk_radio_button_new_with_label(NULL, "Small");
	gtk_box_pack_start(GTK_BOX(column), small, FALSE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(small));
	gtk_signal_connect(GTK_OBJECT(small), "pressed",
		GTK_SIGNAL_FUNC(SizeCallback), (gpointer) 1);

	medium = gtk_radio_button_new_with_label(group, "Medium");
	gtk_box_pack_start(GTK_BOX(column), medium, FALSE, TRUE, 0);
	group = gtk_radio_button_group(GTK_RADIO_BUTTON(medium));
	gtk_signal_connect(GTK_OBJECT(medium), "pressed",
		GTK_SIGNAL_FUNC(SizeCallback), (gpointer) 2);

	large = gtk_radio_button_new_with_label(group, "Large");
	gtk_box_pack_start(GTK_BOX(column), large, FALSE, TRUE, 0);
	gtk_signal_connect(GTK_OBJECT(large), "pressed",
		GTK_SIGNAL_FUNC(SizeCallback), (gpointer) 3);


	/* get the setting from the configuration file */

	size = GetConfigInt("Display", "Size", 1, config);
	SetSizeRadioButtons(size);

	label = gtk_label_new("Size");	
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), box, label);

	return;
}


/*
 * Create the Display settings Dialog
 */
void DisplayDialog(void)
{
	static GtkWidget *window = NULL;
	GtkWidget *notebook;

	if (!window) {
		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

		gtk_signal_connect(GTK_OBJECT(window), "destroy",
			GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);

		gtk_window_set_title(GTK_WINDOW(window), "Display");
		gtk_container_border_width(GTK_CONTAINER(window), 6);

		/* create a new notebook, place the position of the tabs */

		notebook = gtk_notebook_new();
		gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
		gtk_container_add(GTK_CONTAINER(window), notebook);
		gtk_widget_show(notebook);

		/* add the three pages to the notebook */

		AddStylePage(notebook, window);
		AddModulesPage(notebook, window);
		AddSizePage(notebook, window);

		/* set to start at first page */

		gtk_notebook_set_page(GTK_NOTEBOOK(notebook), 0);
	}

	if (!GTK_WIDGET_VISIBLE(window))
		gtk_widget_show_all(window);
	else
		gtk_widget_destroy(window);


	return;
}
