/* update.c -- functions to update the display TuxTime
 *
 * Copyright (c) 1996/99  Jonathan A. Buzzard (jonathan@buzzard.org.uk)
 *
 * $Log: update.c,v $
 * Revision 1.1  1999/06/23 19:09:54  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

static const char rcsid[]="$Id: update.c,v 1.1 1999/06/23 19:09:54 jab Exp jab $";


#include<stdio.h>
#include<stdlib.h>
#include<string.h>
#include<unistd.h>
#include<signal.h>
#include<paths.h>
#include<pwd.h>
#include<features.h>
#ifdef __GLIBC__
#include<sys/perm.h>
#endif
#include<gtk/gtk.h>


#include"sci.h"
#include"misc.h"
#include"alarms.h"
#include"config.h"

#include"batterylow.xpm"
#include"batterycharged.xpm"

GtkWidget *progress;
GtkWidget *percent;
GtkWidget *time;

GdkPixmap *lowpixmap,*chargedpixmap;
GdkBitmap *lowmask,*chargedmask;

static int modules;
static BatteryAlarm low,critical;
static int lowflag = 0;
static int criticalflag = 0;

#define MINUTES(h,m) ((h*60)+m)

#define TIME_BATTERY_ALERT \
"You computer's battery power is low.\n\
You have approximately %d minutes\n\
left on this battery"

#define PERCENT_BATTERY_ALERT \
"You computer's battery power is low.\n\
Only %d%% of total battery capacity\n\
remains"

#define EMERGENCY_BATTERY_ALERT \
"You have almost no battery\n\
capacity left on this battery!\n\
Find an alternative power source\n\
immediately!"


/*
 * Set which modules are showing
 */
void SetModules(int data)
{
	modules = data;

	return;
}


/*
 * Setup the alarm values by reading them in from the config file
 */
void SetupAlarms(void)
{
	char buffer[8];

	low.percent = GetConfigInt("AlarmLow", "Percent", 20, config);
	low.trigger = GetConfigInt("AlarmLow", "Trigger", 3, config);
	GetConfigString("AlarmLow", "Time", "00:20", buffer, 8, config);
	ConvertTime(buffer, &(low.hour), &(low.minute));
	critical.percent = GetConfigInt("AlarmCritical", "Percent", 10, config);
	critical.trigger = GetConfigInt("AlarmCritical", "Trigger", 3, config);
	GetConfigString("AlarmCritical", "Time", "00:10", buffer, 8, config);
	ConvertTime(buffer, &(critical.hour), &(critical.minute));

	return;
}


/*
 * Close the battery alarm dialog
 */
void BatteryAlarmOkCallback(GtkWidget *widget, gpointer *data)
{
	gtk_widget_destroy(GTK_WIDGET(data));
	gdk_pixmap_unref(chargedpixmap);

	return;
}


/*
 * Display low and critical battery alarm dialogs
 */
void BatteryAlarmDialog(int type, int life)
{
	GtkWidget *window,*button,*label,*box,*icon;
	GdkColor *transparent = NULL;
	char buffer[128];

	if (((type & 0xfff)==TIME_ALARM) && (libretto==1))
		return;

	window = gtk_dialog_new();

	/* handle the window manager close signal */

	gtk_signal_connect(GTK_OBJECT(window), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &(window->window));

	/* set window title */

	switch (type & 0xf000) {
		case LOW_ALARM:
			gtk_window_set_title(GTK_WINDOW(window),
				"Low Battery Alarm");
			break;
		case CRITICAL_ALARM:
			gtk_window_set_title(GTK_WINDOW(window),
				"Critical Battery Alarm");
			break;
		default:
			gtk_window_set_title(GTK_WINDOW(window),
				"Unknown Battery Alarm");
			break;
	}

	/* add the Ok button */

	button = gtk_button_new_with_label("Ok");
	gtk_widget_set_usize(button, 60, 20);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(BatteryAlarmOkCallback), GTK_OBJECT(window));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area), button,
		FALSE, FALSE, 0);

	/* draw the message area */

	box = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox), box,
		TRUE, TRUE, 0);

	/* create the pixmaps used by the dialog */

	chargedpixmap = gdk_pixmap_create_from_xpm_d(window->window,
			&chargedmask, transparent, batterycharged_xpm);

	icon = gtk_pixmap_new(chargedpixmap, chargedmask);
	gtk_box_pack_start(GTK_BOX(box), icon, FALSE, FALSE, 4);

	switch (type & 0x0fff) {
		case TIME_ALARM:
			sprintf(buffer, TIME_BATTERY_ALERT, life);
			break;
		case PERCENT_ALARM:
			sprintf(buffer, PERCENT_BATTERY_ALERT, life);
			break;
		default:
			sprintf(buffer, "Unknown battery alarm type");
			break;
	}
	
	label = gtk_label_new(buffer);
	gtk_misc_set_padding(GTK_MISC(label), 10, 10);
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, TRUE, 0);

	gtk_widget_show_all(window);

	return;
}


/*
 * Close the battery alarm dialog
 */
void EmergencyAlarmOkCallback(GtkWidget *widget, gpointer *data)
{
	gtk_widget_destroy(GTK_WIDGET(data));
	gdk_pixmap_unref(lowpixmap);

	return;
}


/*
 * Display the emergency low battery alarm dialog
 */
void EmergencyAlarmDialog(void)
{
	GtkWidget *window,*button,*label,*box,*icon;
	GdkColor *transparent = NULL;

	window = gtk_dialog_new();

	/* handle the window manager close signal */

	gtk_signal_connect(GTK_OBJECT(window), "destroy",
		GTK_SIGNAL_FUNC(gtk_widget_destroyed), &(window->window));

	/* set window title */

	gtk_window_set_title(GTK_WINDOW(window), "Emergency Battery Alert!");

	/* add the Ok button */

	button = gtk_button_new_with_label("Ok");
	gtk_widget_set_usize(button, 60, 20);
	gtk_signal_connect(GTK_OBJECT(button), "clicked",
		GTK_SIGNAL_FUNC(EmergencyAlarmOkCallback), GTK_OBJECT(window));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area), button,
		FALSE, FALSE, 0);

	/* draw the message area */

	box = gtk_hbox_new(FALSE, 4);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox), box,
		TRUE, TRUE, 0);

	/* create the pixmaps used by the dialog */

	lowpixmap = gdk_pixmap_create_from_xpm_d(window->window,
			&lowmask, transparent, batterylow_xpm);

	icon = gtk_pixmap_new(chargedpixmap, chargedmask);
	gtk_box_pack_start(GTK_BOX(box), icon, FALSE, FALSE, 4);

	label = gtk_label_new(EMERGENCY_BATTERY_ALERT);
	gtk_misc_set_padding(GTK_MISC(label), 10, 10);
	gtk_box_pack_start(GTK_BOX(box), label, FALSE, TRUE, 0);

	gtk_widget_show_all(window);

	return;
}


/*
 * Test to see if any battery alarm dialogs need displaying
 */
void AlarmTest(int type, int *flag, BatteryAlarm *settings, int lifepercent,
	int lifetime)
{

	if ((settings->trigger==TIME_ALARM) || (settings->trigger==BOTH_ALARM))
		if ((lifetime<=MINUTES(settings->hour, settings->minute))
					&& (((*flag) & TIME_ALARM)==0)) {
			BatteryAlarmDialog(type | TIME_ALARM, lifetime);
			*flag |= TIME_ALARM;
		} else if (lifetime>MINUTES(settings->hour, settings->minute)) {
				*flag ^= TIME_ALARM;
		}
			
	if ((settings->trigger==PERCENT_ALARM) || (settings->trigger==BOTH_ALARM))
		if ((lifepercent<=settings->percent) &&
					(((*flag) & PERCENT_ALARM)==0)) {
			BatteryAlarmDialog(type | PERCENT_ALARM, lifepercent);
			*flag |= PERCENT_ALARM;
		} else if (lifepercent>settings->percent) {
			*flag ^= PERCENT_ALARM;
		}

	return;
}


/*
 * Update the battery life remaining display, and switch settings if the
 * power source has changed
 */
gint Update(gpointer data)
{
	SciRegisters reg;
	unsigned short timelife,percentlife;
	int hour,minute;
	int error;
	char buffer[8];

	timelife = 0;
	percentlife = 0;

	/* update the percent remaining */

	reg.setting = SCI_BATTERY_PERCENT;
	error = GetSetting(&reg, ERROR_CONSOLE);
	if (error==SCI_SUCCESS) {
		percentlife = (100*reg.current)/reg.possible;
		gtk_progress_bar_update(GTK_PROGRESS_BAR(progress),
			(gfloat) percentlife/100.0);
		sprintf(buffer, "%d%%", percentlife);
		gtk_label_set(GTK_LABEL(percent), buffer);
	}
	
	/* update the time remaining  */

	if (!libretto) {
		reg.setting = SCI_BATTERY_TIME;
		error = GetSetting(&reg, ERROR_CONSOLE);
		if (error==SCI_SUCCESS) {
			timelife = reg.current;
			sprintf(buffer,"%d:%02d", SCI_HOUR(timelife),
				SCI_MINUTE(timelife));
			gtk_label_set(GTK_LABEL(time), buffer);
		} else {
			gtk_label_set(GTK_LABEL(time), "?:??");
		}
	}

/*	if (percentlife<=80)
		gtk_widget_hide(GTK_WIDGET(progress));
*/
	/* test for emergency battery alarm */

	if (percentlife<3)
		EmergencyAlarmDialog();

	/* test for the user settable battery alarm conditions */

	hour = SCI_HOUR(timelife);
	minute = SCI_MINUTE(timelife);
	AlarmTest(LOW_ALARM, &lowflag, &low, percentlife,
		MINUTES(hour, minute));
	AlarmTest(CRITICAL_ALARM, &criticalflag, &critical, percentlife,
		MINUTES(hour, minute));
		
	return TRUE;
}
