/* misc.h -- function prototypes for TuxTime's callback functions
 *
 * Copyright (c) 1996/98  Jonathan A. Buzzard (jab@hex.prestel.co.uk)
 *
 * $Log: misc.h,v $
 * Revision 1.2  1998/08/16 17:10:02  jab
 * added alarm time fuctions and updated settings stuff for error message type
 *
 * Revision 1.1  1998/08/13 23:35:56  jab
 * Initial revision
 *
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef MISC_H
#define MISC_H

#define PID_FILE "tuxtime.pid"

enum {
	ERROR_GUI = 0,
	ERROR_CONSOLE
};

enum {
	ERROR_OPEN,
	ERROR_SET,
	ERROR_GET,
	ERROR_MESSAGE,
	ERROR_UNKNOWN
};

enum {
	BUTTONS_ALARM,
	BUTTONS_DISPLAY,
	BUTTONS_SETTING
};


extern int id;
extern int libretto;
extern char model[8];
extern char *config;

void GuiError(int type, char *message);
int GetSetting(SciRegisters *reg, int errtype);
int SetSetting(unsigned short mode, unsigned short status, int gui);

int ctoi(char *s);
int ConvertTime(char *time, int *hour, int *minute);

void CreateDefaultRC(char *file);

void AddButtons(GtkWidget *box, GtkWidget *window, int type);
void OkCallback(GtkWidget *widget, gpointer *data);
void ExitCallback(GtkWidget *widget, GdkEventButton *event, gpointer *data);
void AboutCallback(GtkWidget *widget, GdkEventButton *event, gpointer *data);

#endif
