; svpw.asm - set the supervisor passwords on a 400 series Toshiba.
;
; when assembled with NASM should produce a file indentical to svpw.exe
; (note: this is not finished and does not even compile)
;
;
; $Log:$
;
;

[BITS 16]
[ORG 0x100]

        BS EQU 08h      ; backspace
        HT EQU 09h      ; horizontal tab
        LF EQU 0Ah      ; line feed
        CR EQU 0Dh      ; carrage return

        DB '(c) COPYRIGHT 1995 Toshiba Corporation.'
        DB 'ALL RIGHT RESERVED.     V0.20   05/18/95TCD 002'

        CLD
        STI
        XOR bl,bl       ; set bl to zero
        MOV si,81h
;
; Process the command line
;
start:
        LODSB
        CMP al,CR
        JE done
        CMP al,' '
        JE start
        CMP al,HT
        JE start
        CMP al,'/'		
        JNE funny
        LODSB
        CMP al,CR
        JE done
        CMP al,' '
        JE start
        CMP al,HT
        JE start
        CMP al,'U'
        JE user
        CMP al,'u'
        JE user
        CMP al,'?'
        JNE start
        OR bl,80h       ; set bit 7 if help
        NOP
        JMP start
user:
        OR bl,40h       ; set bit 6 if user
        NOP
        JMP start
funny:
        JMP start
done:
        MOV ax,cs
        MOV ds,ax
        MOV es,ax
        MOV [line],bl   ; store command line option
        MOV ax,44F0h    ; TOSH BIOS CALL - support check
        INT 15h
        JB notosh       ; jump if CF=1
        CMP ax,0044h
        JNE notosh

        MOV ax,44F1h    ; TOSH BIOS CALL - open interface
        INT 15h
        JAE maybe       ; jump if CF=0
        CMP ah,81h
        JE open         ; successfully opened interface
        JMP notosh
maybe:
        CMP ax,0044h
        JNE notosh      ; jump if ZF=0 (ie. ax!=0x0044)
open:
        OR [line],8     ; set bit 4 - record interface open
        NOP
        MOV ax,44F3h    ; TOSH BIOS CALL - get
        MOV bx,0602h    ; if supervisor password set?
        MOV cx,0001h
        INT 15h
        JAE set         ; jump if CF=0 (if carry set not a compatible machine)
notosh:
        MOV ah,9
        MOV dx,compat   ; print "Incompatible machine type" 
        INT 21h
        MOV [code],1
        NOP
        JMP exit
set:
        CMP cx,1
        JNE notset
        OR [line],1     ; set bit 1 if supervisor password set
        NOP
        MOV [trys],dl   ; number of attempts left to delete the password
notset:
        TEST [line],80h ; was help requested?
        NOP
        JE nohelp       ; help not on command line
        MOV ah,9
        MOV dx,help     ; print the help string
        INT 21h
        JMP exit
nohelp:
        TEST [line],40h ; was change of user mode requested?
        NOP
        JE nouser       ; changes to user mode not requested
        TEST [line],1   ; is a supervisor password registered?
        NOP
        JNE supreg
        MOV ah,9
        MOV dx,nosuper  ; print "Unable to change user mode ... no supervisor"
        INT 21h
        MOV [code],2
        NOP
        JMP exit
supreg:
        MOV ax,44F3h    ; TOSH BIOS CALL - get
        MOV bx,0604h    ; what is user mode? able/unable to run tsetup
        MOV cx,0000h
        INT 15h
        CALL runset
0131:
        MOV dx,0564     ; set for "change the setting"
        CALL yesno
        JB 0131         ; jump if CF=0, ie. user did not press either Y or N
        JNE sloppy      ; jump if ZF=0, sloppy way to leave program
        MOV ax,44F4h    ; TOSH BIOS CALL - set
        MOV bx,0604h
        XOR cx,0001h
        INT 15h
        CALL runset
sloppy:
        JMP exit
;
; Register/Unregister Supervsor password
;
nouser:
        CALL super
        TEST [line],1   ; is a supervisor already registered?
        NOP
        JNE delete      ; possibly delete supervisor password
0157:
        MOV dx,0577     ; set for "register the supervisor password"
        CALL yesno
        JB 0157
        JNE bad         ; leave program, but sloppy coding
0161:
        MOV dx,05C5     ; set for "Enter password ---> "
        MOV di,pass1
        CALL password   ; store the password
        MOV dx,05DA     ; set for "Verify password --> " 
        MOV di,pass2
        CALL password   ; get verification password
        MOV si,pass1    ; check the two passwords are the same
        MOV di,pass2
        MOV cx,0Ah
        REPE CMPSB
        JE 0194
        MOV ah,9
        MOV dx,05EF     ; print "Password verify error !"
        INT 21h
0187:
        MOV dx,05B7     ;  print "retry"
        CALL yesno
        JB 0187
        JE 0161
        JMP exit
        NOP
0194:
        MOV di,pass1
        CALL store
        OR [line],1     ; Set that a password is stored
        NOP
        CALL super
bad:
        JMP exit
        NOP
delete:
        MOV dx,0598     ; print "delete the supervisor password"
        CALL yesno
        JB delete
        JNE silly       ; leave program, sloppy coding
01B0:
        CMP [trys],0    ; have we run out of attempts to delete the password
        JNE erase
        MOV ah,9
        MOV dx,0609     ; print "Password access denied !"
        INT 021
        MOV [code],3
        NOP
        JMP exit
        NOP
erase:
        MOV dx,05C5     ; print "Enter Password ---> "
        MOV di,pass1
        CALL password
        MOV di,pass1
        CALL store
        JAE 01EF        ; jump if CF=0, ie. password store sucessfull.
        MOV [trys],dl   ; count of remaining attempts (you are allowed three)
        MOV ah,9
        MOV dx,05EF     ; print "Password verify error !"
        INT 21h
01E3:
        MOV dx,05B7     ; print "retry"
        CALL yesno
        JB 01E3
        JNE silly
        JMP 01B0        ; loop and retry deleting the password
01EF:
        AND [line],0FEh
        NOP
        CALL super
silly:
        JMP exit
        NOP

exit:
        TEST [line],8   ; is an interface open?
        NOP
        JE dos
        MOV ax,44F2h    ; TOSH BIOS CALL - close interface
        INT 15h
dos:
        MOV al,[code]   ; set exit return code
        MOV ah,4Ch
        INT 21h         ; return to DOS

;
; Store the password
;
store:
        MOV ax,44F4h    ; TOSH BIOS CALL - store the password into the EEPROM
        MOV bx,0602h
        MOV cx,0001h
        MOV edx,[di]
        BSWAP edx       ; Swap bytes 1,4 and 2,3 of edx
        MOV esi,[di+4]
        BSWAP esi       ; Swap bytes 1,4 and 2,3 of esi
        MOV di,[di+8]
        ROL di,8        ; rotate di left eight times (this swaps the bytes)
        INT 15h
        RET
;
; Get a password
;
password:
        MOV ah,9        ; print the password prompt
        INT 21h
        PUSH di
        MOV cx,000Ah
        XOR al,al       ; set al to zero
        REP STOSB       ; blank password Store AL to byte ES:[DI], advance DI 
        POP di
        XOR bx,bx       ; set bx to xero
again
        MOV ah,0        ; get keystroke ah holds BIOS scan code
        INT 16h
        CMP ah,2        ; BIOS scan code for key "1 !"
        JB again
        CMP ah,35h      ; BIOS scan code for key "/ ?"
        JBE 0250
        CMP ah,39h      ; BIOS scan code for SpaceBar
        JNE again
0250:
        CMP ah,0Eh      ; BIOS scan code for Backspace
        JNE 0266
        OR bx,bx        ; set flags
        JE again
        DEC bx          ; go back one character
        MOV [BX+DI],0h  ; wipe character from password
        MOV ah,9
        MOV dx,0624     ; delete character
        INT 021
        JMP again
0266:
        CMP ah,0Fh      ; BIOS scan code for Tab
        JE again
        CMP ah,1Ch      ; BIOS scan code for "Enter"
        JNE 027C
        OR bx,bx
        JE again
        MOV ah,9
        MOV dx,newline  ; print a new line
        INT 21h
        RET             ; finished entering password
027C:
        CMP bx,9        ; does bx=9? if so already entered 10 characters
        JA again        ; jump if above (CF=0 and ZF =0)
        MOV [BX+DI],ah  ; store BIOS scan code into password
        INC bx          ; point to next character
        MOV ah,9
        MOV dx,0628     ; print astrix
        INT 21h
        JMP again
;
; Print whether a supervisor password is registered
;
super:
        MOV ah,9
        MOV dx,052C     ; print "SUPERVISOR PASSWORD = "
        INT 021
        MOV ah,9
        MOV dx,0543     ; set for "Not Registered"
        TEST [line],1
        NOP
        JE notreg
        MOV dx,0547     ; set for "Registered"
notreg:
        INT 21h
        RET
;
; Print whether the user is able to run setup
;
runset:
       MOV ah,9
       MOV dx,04FA     ; print "USER PASSWORD MODE = "
       INT 21h
       MOV ah,9
       MOV dx,0510     ; set for "Unable"
       TEST cl,1
       JNE unable
       MOV dx,0517     ; set for "Able"
unable:
       INT 21h         ; print to screen dx
       MOV ah,9
       MOV dx,051C     ; print " to run SETUP"
       INT 21h
       RET
;
; Get a yes/no answer on a question
;
yesno:
        PUSH dx
        MOV ah,9
        MOV dx,0554     ; print "Do you want to"
        INT 21h
        POP dx          ; passed in
        MOV ah,9
        INT 21h
        MOV ah,9
        MOV dx,05BD     ; print " <Y/N>?"
        INT 21h
        MOV ax,0C01h    ; flush buffer and read standard input
        INT 21h
        CMP al,59h
        JE yes
        CMP al,79h
        JE yes
        CMP al,4Eh
        JE no
        CMP al,6Eh
        JE no
        STC             ; set carry flag ( CF=1 )
        JMP neither
no:
        OR al,al        ; set/reset some flag if no (FIXME poss ZF=1/0)
yes:
        CLC             ; clear carry flag ( CF=0 )
neither
        PUSHF           ; save the flags
        MOV ah,9
        MOV dx,newline  ; start a newline
        INT 21h
        POPF            ; restore flags for return
        RET
;
;variables start here
;
line:   DB 0
code:   DB 0
trys:   DB 0

pass1:  DB 0,0,0,0,0,0,0,0,0,0
pass2:  DB 0,0,0,0,0,0,0,0,0,0

;
; Text messages used by the program
;
compat:
        DB 'Incompatiable machine type'
newline:		
		DB CR,LF,'$'
help:
		DB 'This utility can be used to register the supervisor password'
		DB 'and change the userpassword mode (allowed or not allowed to run '
		DB 'SETUP).',CR,LF,CR,LF,'c:\patch\SVPW.EXE [/U]',CR,LF
		DB '   without parameters : Display if the supervisor password is '
		DB 'registered or not,                        and allow to register/'
		DB 'delete it.',CR,LF,'   /U : Display the current user password '
		DB 'mode and allow to change it.',CR,LF,'$'
nosuper:		
		DB 'Unable to change user password mode because supervisor password '
		DB 'is not',CR,LF,'regstered.',CR,LF,'$'

        DB 'USER PASSWORD MODE = $'
        DB 'Unable$'
		DB 'Able$'
		DB ' to run SETUP',CR,LF,'$'

		DB 'SUPERVISOR PASSWORD = $'
		DB 'Not '
		DB 'Registered',CR,LF,'$'

		DB 'Do you want to $'
		DB 'change the setting$'
		DB 'register the supervisor password$'
		DB 'delete the supervisor password$'
		DB 'retry$'
		DB ' <Y/N>?$'

		DB 'Enter Password ---> $'
		DB 'Verify Password --> $'
		DB 'Password verify error !',CR,LF,'$'
		DB 'Password access denied !',CR,LF,'$'
		DB BS,' ',BS,'$'
		DB '*$'
